<?php $__env->startSection('title', 'Activity Log'); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .log-container {
        padding: 0;
        margin: 0;
    }

    .log-header {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        padding: 30px 20px;
        margin: 0;
}

    .log-header h1 {
        margin: 0;
        font-size: 28px;
        font-weight: 700;
    }

    .log-header p {
        margin: 8px 0 0 0;
        opacity: 0.9;
        font-size: 14px;
    }

    .filter-section {
        background: white;
        padding: 20px;
        border-bottom: 1px solid #e2e8f0;
    }

    .filter-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 15px;
        margin-bottom: 15px;
    }

    .filter-item {
        display: flex;
        flex-direction: column;
    }

    .filter-label {
        font-size: 13px;
        font-weight: 600;
        color: #4a5568;
        margin-bottom: 6px;
    }

    .filter-input,
    .filter-select {
        padding: 10px 12px;
        border: 2px solid #e2e8f0;
        border-radius: 8px;
        font-size: 14px;
        transition: all 0.3s;
    }

    .filter-input:focus,
    .filter-select:focus {
        outline: none;
        border-color: #667eea;
        box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    }

    .filter-buttons {
        display: flex;
        gap: 10px;
    }

    .btn-filter {
        padding: 10px 20px;
        border: none;
        border-radius: 8px;
        font-weight: 600;
        font-size: 14px;
        cursor: pointer;
        transition: all 0.3s;
        display: inline-flex;
        align-items: center;
        gap: 6px;
    }

    .btn-filter.primary {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
    }

    .btn-filter.primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(102, 126, 234, 0.4);
    }

    .btn-filter.secondary {
        background: #e2e8f0;
        color: #4a5568;
    }

    .btn-filter.secondary:hover {
        background: #cbd5e0;
    }

    .stats-cards {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 15px;
        padding: 20px;
        background: #f7fafc;
        border-bottom: 1px solid #e2e8f0;
    }

    .stat-card {
        background: white;
        padding: 20px;
        border-radius: 12px;
        border-left: 4px solid;
        box-shadow: 0 2px 8px rgba(0,0,0,0.05);
    }

    .stat-card.total {
        border-left-color: #667eea;
    }

    .stat-card.create {
        border-left-color: #48bb78;
    }

    .stat-card.update {
        border-left-color: #ed8936;
    }

    .stat-card.delete {
        border-left-color: #f56565;
    }

    .stat-label {
        font-size: 12px;
        color: #718096;
        font-weight: 600;
        text-transform: uppercase;
        margin-bottom: 8px;
    }

    .stat-value {
        font-size: 28px;
        font-weight: 700;
        color: #2d3748;
    }

    .stat-icon {
        float: right;
        font-size: 24px;
        opacity: 0.3;
    }

    .log-list {
        background: white;
        padding: 20px;
    }

    .log-item {
        padding: 15px;
        border-bottom: 1px solid #e2e8f0;
        transition: all 0.3s;
        display: flex;
        gap: 15px;
        align-items: flex-start;
    }

    .log-item:hover {
        background: #f7fafc;
        padding-left: 20px;
    }

    .log-item:last-child {
        border-bottom: none;
    }

    .log-icon {
        width: 45px;
        height: 45px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 18px;
        flex-shrink: 0;
    }

    .log-icon.create {
        background: #c6f6d5;
        color: #22543d;
    }

    .log-icon.update {
        background: #feebc8;
        color: #7c2d12;
    }

    .log-icon.delete {
        background: #fed7d7;
        color: #742a2a;
    }

    .log-icon.approve {
        background: #bee3f8;
        color: #2c5282;
    }

    .log-icon.reject {
        background: #fef5e7;
        color: #975a16;
    }

    .log-content {
        flex: 1;
    }

    .log-header-row {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        margin-bottom: 6px;
    }

    .log-user {
        font-weight: 700;
        color: #2d3748;
        font-size: 15px;
    }

    .log-time {
        font-size: 12px;
        color: #a0aec0;
    }

    .log-description {
        color: #4a5568;
        font-size: 14px;
        margin-bottom: 8px;
        line-height: 1.5;
    }

    .log-meta {
        display: flex;
        flex-wrap: wrap;
        gap: 10px;
        font-size: 12px;
    }

    .meta-badge {
        display: inline-flex;
        align-items: center;
        gap: 4px;
        padding: 4px 10px;
        border-radius: 12px;
        font-weight: 600;
    }

    .meta-badge.module {
        background: #e6fffa;
        color: #234e52;
    }

    .meta-badge.action {
        background: #fef5e7;
        color: #975a16;
    }

    .meta-badge.role {
        background: #e9d8fd;
        color: #44337a;
    }

    .meta-badge.ip {
        background: #e2e8f0;
        color: #2d3748;
    }

    .pagination-wrapper {
        padding: 20px;
        display: flex;
        justify-content: center;
        background: white;
        border-top: 1px solid #e2e8f0;
    }

    .empty-state {
        text-align: center;
        padding: 60px 20px;
        color: #a0aec0;
    }

    .empty-state i {
        font-size: 64px;
        margin-bottom: 15px;
        opacity: 0.5;
    }

    .empty-state p {
        font-size: 16px;
        margin: 0;
    }

    @media (max-width: 768px) {
        .log-header {
            padding: 20px 15px;
        }

        .log-header h1 {
            font-size: 22px;
        }

        .filter-grid {
            grid-template-columns: 1fr;
        }

        .stats-cards {
            grid-template-columns: repeat(2, 1fr);
            padding: 15px;
        }

        .log-item {
            flex-direction: column;
            align-items: stretch;
        }

        .log-icon {
            align-self: flex-start;
        }

        .log-header-row {
            flex-direction: column;
            gap: 8px;
        }

        .filter-buttons {
            flex-direction: column;
        }

        .btn-filter {
            width: 100%;
            justify-content: center;
        }
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="log-container">
    
    <div class="log-header">
        <h1><i class="fas fa-history"></i> Activity Log</h1>
        <p>Riwayat aktivitas pengguna di sistem</p>
    </div>

    
    <div class="filter-section">
        <form action="<?php echo e(route('admin.activity-log.index')); ?>" method="GET">
            <div class="filter-grid">
                <div class="filter-item">
                    <label class="filter-label">Cari User</label>
                    <input type="text" name="search" class="filter-input"
                           placeholder="Nama user..."
                           value="<?php echo e(request('search')); ?>">
                </div>

                <div class="filter-item">
                    <label class="filter-label">Role</label>
                    <select name="role" class="filter-select">
                        <option value="">Semua Role</option>
                        <option value="super_admin" <?php echo e(request('role') == 'super_admin' ? 'selected' : ''); ?>>Super Admin</option>
                        <option value="admin" <?php echo e(request('role') == 'admin' ? 'selected' : ''); ?>>Admin</option>
                        <option value="karyawan" <?php echo e(request('role') == 'karyawan' ? 'selected' : ''); ?>>Karyawan</option>
                    </select>
                </div>

                <div class="filter-item">
                    <label class="filter-label">Module</label>
                    <select name="module" class="filter-select">
                        <option value="">Semua Module</option>
                        <option value="cuti" <?php echo e(request('module') == 'cuti' ? 'selected' : ''); ?>>Cuti</option>
                        <option value="absensi" <?php echo e(request('module') == 'absensi' ? 'selected' : ''); ?>>Absensi</option>
                        <option value="shift" <?php echo e(request('module') == 'shift' ? 'selected' : ''); ?>>Shift</option>
                        <option value="jadwal_shift" <?php echo e(request('module') == 'jadwal_shift' ? 'selected' : ''); ?>>Jadwal Shift</option>
                        <option value="karyawan" <?php echo e(request('module') == 'karyawan' ? 'selected' : ''); ?>>Karyawan</option>
                        <option value="user" <?php echo e(request('module') == 'user' ? 'selected' : ''); ?>>User</option>
                    </select>
                </div>

                <div class="filter-item">
                    <label class="filter-label">Action</label>
                    <select name="action" class="filter-select">
                        <option value="">Semua Action</option>
                        <option value="create" <?php echo e(request('action') == 'create' ? 'selected' : ''); ?>>Create</option>
                        <option value="update" <?php echo e(request('action') == 'update' ? 'selected' : ''); ?>>Update</option>
                        <option value="delete" <?php echo e(request('action') == 'delete' ? 'selected' : ''); ?>>Delete</option>
                        <option value="approve" <?php echo e(request('action') == 'approve' ? 'selected' : ''); ?>>Approve</option>
                        <option value="reject" <?php echo e(request('action') == 'reject' ? 'selected' : ''); ?>>Reject</option>
                    </select>
                </div>

                <div class="filter-item">
                    <label class="filter-label">Dari Tanggal</label>
                    <input type="date" name="date_from" class="filter-input"
                           value="<?php echo e(request('date_from')); ?>">
                </div>

                <div class="filter-item">
                    <label class="filter-label">Sampai Tanggal</label>
                    <input type="date" name="date_to" class="filter-input"
                           value="<?php echo e(request('date_to')); ?>">
                </div>
            </div>

            <div class="filter-buttons">
                <button type="submit" class="btn-filter primary">
                    <i class="fas fa-search"></i> Filter
                </button>
                <a href="<?php echo e(route('admin.activity-log.index')); ?>" class="btn-filter secondary">
                    <i class="fas fa-redo"></i> Reset
                </a>
            </div>
        </form>
    </div>

    
    <div class="stats-cards">
        <div class="stat-card total">
            <i class="fas fa-list stat-icon"></i>
            <div class="stat-label">Total Log</div>
            <div class="stat-value"><?php echo e($stats['total'] ?? 0); ?></div>
        </div>
        <div class="stat-card create">
            <i class="fas fa-plus-circle stat-icon"></i>
            <div class="stat-label">Create</div>
            <div class="stat-value"><?php echo e($stats['create'] ?? 0); ?></div>
        </div>
        <div class="stat-card update">
            <i class="fas fa-edit stat-icon"></i>
            <div class="stat-label">Update</div>
            <div class="stat-value"><?php echo e($stats['update'] ?? 0); ?></div>
        </div>
        <div class="stat-card delete">
            <i class="fas fa-trash stat-icon"></i>
            <div class="stat-label">Delete</div>
            <div class="stat-value"><?php echo e($stats['delete'] ?? 0); ?></div>
        </div>
    </div>

    
    <div class="log-list">
        <?php $__empty_1 = true; $__currentLoopData = $logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div class="log-item">
            <div class="log-icon <?php echo e($log->action); ?>">
                <?php if($log->action == 'create'): ?>
                    <i class="fas fa-plus"></i>
                <?php elseif($log->action == 'update'): ?>
                    <i class="fas fa-edit"></i>
                <?php elseif($log->action == 'delete'): ?>
                    <i class="fas fa-trash"></i>
                <?php elseif($log->action == 'approve'): ?>
                    <i class="fas fa-check"></i>
                <?php elseif($log->action == 'reject'): ?>
                    <i class="fas fa-times"></i>
                <?php else: ?>
                    <i class="fas fa-info"></i>
                <?php endif; ?>
            </div>

            <div class="log-content">
                <div class="log-header-row">
                    <div class="log-user">
                        <?php echo e($log->user ? $log->user->nama : 'System'); ?>

                    </div>
                    <div class="log-time">
                        <i class="far fa-clock"></i>
                        <?php echo e($log->created_at->diffForHumans()); ?>

                    </div>
                </div>

                <div class="log-description">
                    <?php echo e($log->description); ?>

                </div>

                <div class="log-meta">
                    <span class="meta-badge module">
                        <i class="fas fa-cube"></i> <?php echo e(ucfirst($log->module)); ?>

                    </span>
                    <span class="meta-badge action">
                        <i class="fas fa-bolt"></i> <?php echo e(ucfirst($log->action)); ?>

                    </span>
                    <?php if($log->role): ?>
                    <span class="meta-badge role">
                        <i class="fas fa-user-tag"></i> <?php echo e(ucfirst(str_replace('_', ' ', $log->role))); ?>

                    </span>
                    <?php endif; ?>
                    <?php if($log->ip_address): ?>
                    <span class="meta-badge ip">
                        <i class="fas fa-network-wired"></i> <?php echo e($log->ip_address); ?>

                    </span>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <div class="empty-state">
            <i class="fas fa-inbox"></i>
            <p>Tidak ada activity log ditemukan</p>
        </div>
        <?php endif; ?>
    </div>

    
    <?php if($logs->hasPages()): ?>
    <div class="pagination-wrapper">
        <?php echo e($logs->links()); ?>

    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\DAVA\Documents\FILE_SEKOLAH\WEB XII\absensi-hotel - Copy\resources\views/admin/activity-log/index.blade.php ENDPATH**/ ?>